LPARAMETERS cSample, cAction
IF PCOUNT() != 2 OR TYPE("cSample") != "C" OR TYPE("cAction") != "C"
	RETURN
ENDIF

LOCAL lcFile, lcSuffix, lcPath
m.lcFile = ""
m.lcPath = ""
cSample = UPPER(cSample)
cAction = UPPER(cAction)

m.lcSuffix = IIF(cAction = "MODIFY", ".PJX", ".APP")

#DEFINE ERROR_LOC "Error"
#DEFINE ERR1_LOC "File not found." + CHR(13) + "Please make sure the following file is installed:" + CHR(13)
#DEFINE SPATH "Solution\"
#DEFINE SFILE "solution"
#DEFINE TTPATH "Tastrade\"
#DEFINE TTFILE "tastrade"
#DEFINE CSPATH "CSApp\"
#DEFINE CSFILE "sample"
#DEFINE POOLPATH "Servers\Poolmgr\"
#DEFINE POOLFILE "pool"
#DEFINE GOPHERPATH "Servers\Gopher\"
#DEFINE GOPHERFILE "foxsrch"
#DEFINE ISAPIPATH "Servers\Foxisapi\FoxWeb\"
#DEFINE ISAPIFILE "foxweb"


DO CASE 
	CASE cSample = "SOLUTION"
	*------------------------
		m.lcPath = HOME(2) + SPATH
		m.lcFile = SFILE + m.lcSuffix
		
	CASE cSample = "TASTRADE"
	*------------------------
		m.lcPath = HOME(2) + TTPATH
		m.lcFile =  TTFILE + m.lcSuffix
		
	CASE cSample = "SAMPLE"
	*------------------------
		m.lcPath = HOME(2) + CSPATH
		m.lcFile = CSFILE + m.lcSuffix

	CASE cSample = "POOL"
	*------------------------
		m.lcPath = HOME(2) + POOLPATH
		m.lcFile = POOLFILE + m.lcSuffix
		cAction = "MODIFY"
		
	CASE cSample = "FOXSRCH"
	*------------------------
		m.lcPath = HOME(2) + GOPHERPATH
		m.lcFile = GOPHERFILE + m.lcSuffix
		cAction = "MODIFY"
		
	CASE cSample = "FOXWEB"
	*------------------------
		m.lcPath = HOME(2) + ISAPIPATH
		m.lcFile = ISAPIFILE + m.lcSuffix
		cAction = "MODIFY"
		
	OTHERWISE
	*------------------------
		RETURN		
ENDCASE
IF _SCREEN.WindowState = 1 && minimized
	_SCREEN.WindowState = 0 && normal
ENDIF

IF !FILE(m.lcPath + m.lcFile)
		MESSAGEBOX(ERR1_LOC + CHR(13) + CHR(13) + m.lcPath + m.lcFile, 48+0+0, ERROR_LOC)
		RETURN
	ENDIF
DO CASE 
	CASE cAction = "MODIFY"
		MODIFY PROJECT (m.lcPath + m.lcFile) NOWAIT
	CASE cAction = "RUN"
		CLOSE DATA ALL
		CD (lcPath)
		ACTIVATE WINDOW COMMAND
		KEYBOARD "DO " + m.lcFile + '{ENTER}'
ENDCASE

